#include "Mushroom.h"


Mushroom::Mushroom()
{
	spriteType = SpriteType::MushroomSprite;

	moveableTexture.loadFromFile("Assets/Sprites/Moveables/mushroom.png");	//Load the mushroom texture
	setTexture(&moveableTexture);
	setCollisionBox(0, 0, 50, 50);
	setSize(sf::Vector2f(50, 50));
	setVelocity(125, 0);	//Have the mushroom move initally toward the right
}


Mushroom::~Mushroom()
{
}

void Mushroom::handleCollision(MySprite* sprite, float dt)
{
	//Only Mario can possible collide, so it's safe to assume and cast the MySprite object to a Mario object
	Mario* mario = (Mario*)sprite;	//Cast to access Mario specific functions
	setAlive(false);	//Kill the mushroom
	mario->powerUp();	//Power Mario up due to the mushroom collision
}